//Coulson & Richardson Chemical Engineering, Volume-01, 6th edition
//Chappter:9, Heat transfer
//Exercise:9.9, Page No.:429
//Title: Forced convection outside tubes
//============================================
package Ex9_9
  class i
    //==============================================
    //Variable section
    Real ho(unit = "W/m2K") "Tube side coefficient based on outside area";
    //==============================================
    //Parameter section
    parameter Real hi(unit = "W/m2K") = 1000 "Tube side coefficient based on inside area";
    parameter Real di(unit = "m") = 15e-3 "Inner diameter of tube";
    parameter Real do(unit = "m") = 19e-3 "Outer diameter of tube";
    //==============================================
    //Equation section
  equation
    ho = hi * di / do;
  end i;

  class ii
  
  //===========================================
  //Variable section
  Real Area(unit = "m2") "Area for flow";
  Real G_s(unit = "kg/m2s") "mass flowrate per area";
  Real ho(unit = "W/m2K") "outside heat transfer coefficient";
  Real de(unit = "m") "Hydraulic mean diameter";
  
  //===========================================
  //Parameter section
  parameter Real k(unit = "W/mK") = 0.15 "Thermal conductivity";
  parameter Real mu(unit = "Ns/m2") = 0.7e-3 "Viscosity of nitrobenzene";
  parameter Real Cp(unit = "J/kgK") = 2380 "Specific heat of nitrobenzene";
  parameter Real di(unit = "m") = 15e-3 "Inner diameter of tube";
  parameter Real do(unit = "m") = 19e-3 "Outer diameter of tube";
  parameter Real Y(unit = "m") = 25e-3 "Square pitch";
    parameter Real lB(unit = "m") = 150e-3 "Baffle spacing";
    parameter Real C(unit = "m") = 6e-3 "Clearance";
    parameter Real ds(unit = "m") = 0.44 "Shell diameter";
    parameter Real G(unit = "kg/s") = 4 "Mass flowrate";
    
  //============================================
  //Library section
  extends Modelica.Constants;
  
  //============================================
  //Equation section
  equation
  Area = (ds*lB*C)/Y;
  G_s = G/Area;
  de = 4*(((Y^2)-((pi*(do^2))/4))/(pi*do));
  ho = 0.36*(k/de)*(((de*G_s)/mu)^0.55)*(((Cp*mu)/k)^0.33);
  
  end ii;

  class iii
  //========================================
  //Variable section
  Real del_Tm(unit = "K") "Temperature difference";
  Real del_T(unit = "K") "Corrected temperature difference";
  Real Q(unit = "W") "Heat load";
  Real Uo(unit = "W/m2K") "Overall heat transfer coefficent";
  
  //========================================
  parameter Real N = 166 "Number of tubes";
  parameter Real F = 0.8 "Correction factor";
  parameter Real Thi(unit = "K") = 400 "Temperature at which nitrobenzene is entering";
  parameter Real Tho(unit = "K") = 315 "Temperature at which nitrobenzene is leaving after cooling";
  parameter Real Tci(unit = "K") = 305 "Temperature at which benzene is entering to cool nitrobenzene";
  parameter Real Tco(unit = "K") = 345 "Temperature at which benzene is leaving heat exchanger";
  parameter Real G(unit = "kg/s") = 4 "Mass flowrate";
  parameter Real Cp(unit = "J/kgK") = 2380 "Specific heat of nitrobenzene";
  parameter Real l(unit = "m") = 5 "length of tube";
  parameter Real S(unit = "m2") = 0.0598 "Surface area of each tube";
  
  //========================================
  //Libaray section
  extends Modelica.Math;
  
  //=========================================
  //Equation section
  equation
  del_Tm = ((Thi-Tco)-(Tho-Tci))/(log((Thi-Tco)/(Tho-Tci)));
  del_T = F*del_Tm;
  Q = G*Cp*(Thi- Tho);
  Uo = Q/(del_T*2*N*l*S);
  
  end iii;

  class iv
  //========================================
  //Variable section
  Real Rd(unit = "m2K/W") "Scale resistance";
  
  //=========================================
  //Parameter section
  parameter Real Uo(unit = "W/m2K") = 386.2 "Overall heat transfer coefficient";
  parameter Real ho(unit = "W/m2K") = 750 "outside heat transfer coefficient";
  parameter Real hi(unit = "W/m2K") = 1000 "Tube side coefficient based on inside area";
  
  //=========================================
  //Equation section
  equation
  Rd = ((1/Uo)-(1/ho)-(1/hi));
  
  end iv;
end Ex9_9;
