//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 10:Differential Mass, Heat and Momentum Balances
//Example 10.2 Page 195
//Title: Two parallel flat plates with Bingham plastic fluid
//--------------------------------------------------
model Ex10_2
//--------------------------------------------------
//Parameter Section
parameter Real x1(unit = "ft")=0;
parameter Real x2(unit = "ft")=(2/12) "Distance between the plates";
parameter Real v1(unit = "ft/min")=10 "Velocity of plate 1";
parameter Real v2(unit = "ft/min")=-35 "Velocity of plate 2 in opposite direction";
parameter Real mu(unit = "lb/(ft.hr)")=363 "Viscosity of Fluid between the plates";
parameter Real gc(unit = "ft/(hr^2)")=4.17e+08 "Acceleration due to gravity";
parameter Real tau0(unit = "lbf/(ft^2)")=0.01 "Yield stress";
//--------------------------------------------------
//Variable Section
Real tauy(unit = "lbf/(ft^2)") "Shear stress on each plate at a distance y";
//--------------------------------------------------
//Equation Section
equation
//By equation 9.65 and 10.28
tauy = (-(mu/gc)*((60*(v2-v1))/(x2-x1))) + tau0;

end Ex10_2;