//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 11: Equations of Change
//Example 11.4 Page 223
//Title: Temperature at Center plane of Slab
//--------------------------------------------------
model Ex11_4
//--------------------------------------------------
//Parameter Section
parameter Real T_0(unit = "degC")=540 "Initial Temperature";
parameter Real T1(unit = "degC")=100 "Temperature of external surfaces at time zero";
parameter Real theta(unit = "s")=1800 "Time";
parameter Real x1(unit = "m")=0.15 "(Thickness of slab)/2";
parameter Real x(unit = "m")=0.075 "Point from the center plane";
parameter Real alpha(unit = "(m^2)/s")=9e-06 "Thermal Diffusivity";
//--------------------------------------------------
//Variable Section
Real T_1(unit = "degC") "Temperature at  center plane of slab";
Real T_2(unit = "degC") "Temperature of slab at x1";
Real A(unit = "NULL") "Exponent Term";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
A = ((pi^2) * alpha * theta)/(4 * (x1^2));
//From equation 11.74, for n=0,1,2
//at centerline x=0, cosine terms are 1 and only the first term is numerically significant
//Equation is reduced to
T_1 = T1 - (((4/pi) * exp(-A)) * (T1 - T_0));

//At x=0.075 m, cosine terms enter and only first term is numerically significant
T_2 = T1 - (((4/pi) * exp(-A) * cos((pi*x)/(2*x1))) * (T1 - T_0));

end Ex11_4;