//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 12: Turbulent-Transport Mechanism
//Example 12.2 Page 243
//Title: Temperature profile in Laminar sub layer
//--------------------------------------------------
model Ex12_2
//--------------------------------------------------
//Parameter Section
parameter Real r1(unit = "ft")=1/12 "Inside Radius of Tube";
parameter Real rho(unit = "lb/(ft^3)")=62.4 "Density of Water";
parameter Real mu(unit = "lb/(ft.s)")=6.72e-4 "Viscosity of Water"; 
parameter Real k(unit = "Btu/(hr.(ft^2).(degF/ft))")=0.354 "Thermal Conductivity of water";
parameter Real cp(unit = "Btu/(lb.degF)")=1 "Specific Heat of water";
parameter Real q_by_A(unit = "Btu/(hr.(ft^2)")=10000 "Heat Flux at the wall and towards the wall";
parameter Real Eq(unit = "(ft^2)/s")=385e-05 "Eddy diffusivity";
//--------------------------------------------------
//Variable Section
Real dT_by_dr_1(unit = "degF/ft") "Temperature gradient in the laminar sub layer";
Real dT_by_dr_2(unit = "degF/ft") "Temperature gradient at r =(r1)/2";
//--------------------------------------------------
//Equation Section
equation
dT_by_dr_1 = -(q_by_A)/k;
//from Equation 12.36 with consistent hour units
dT_by_dr_2 = (q_by_A * 0.5)/(-(k + (rho * cp * Eq * 3600)));

end Ex12_2;