//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.11 Page 281
//Title: Mass & Heat Transfer Coefficient of Potable Water
//----------------------------------------------------
model Ex13_11
//----------------------------------------------------
//Parameter Section
parameter Real d(unit = "ft")=2.5 "Diameter of Lister Bag";
parameter Real vfs(unit = "ft/s")=(0.5*5280) "Wind Velocity";
//Properties of Air at 90 degF & 1 atm,(Appendix D)
parameter Real mu(unit = "cP")=0.0183 "Viscosity";
parameter Real rho(unit = "lb/ft3")=0.0721 "Density";
parameter Real k(unit = "Btu/(hr.ft.degF")=0.014 "Thermal Conductivity";
parameter Real cp(unit = "Btu/(lb.degF")=0.25 "Specific heat capacity";
parameter Real D(unit = "ft2/hr")=1 "Diffusivity";
//From Figure 13.10b,Colburn Factors
parameter Real j_N(unit = "")=0.007 "For Mass Transfer";
parameter Real j_q(unit = "")=0.01 "For Heat Transfer";
//----------------------------------------------------
//Variable Section
Real NPr(unit = "") "Prandtl Number";
Real NSc(unit = "") "Schmidt Number"; 
Real NRe(unit = "") "Reynolds Number";
Real kc(unit = "lbmol/(hr.ft2.(lbmol/ft3))") "Mass transfer coefficient";
Real h(unit = "Btu/(hr.ft2.degF)") "Heat transfer coefficient";
//----------------------------------------------------
//Equation Section
equation
NPr = (cp * mu * 2.42)/k;
NSc = (mu * 2.42)/(rho * D);
NRe = (d * vfs * rho)/(mu * 2.42);
kc = (j_N * vfs)/(NSc ^ (2/3));
h = (j_q * rho * cp * vfs)/(NPr ^ (2/3));

end Ex13_11;