//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.16 Page 298
//Title: Water Boiling @ 500degF: Heat flux & del_T
//----------------------------------------------------
model Ex13_16
//----------------------------------------------------
//Parameter Section
parameter Real Pc(unit = "psia")=3206 "Critical Pressure";
parameter Real P(unit = "psia")=681 "Operating Pressure";
//From figure 13.20a,
parameter Real q_by_A_max_by_Pc(unit = "Btu/(hr.ft2.psia)")=355 "Max. heat flux term in chart";
//From figure 13.20c,
parameter Real del_T_qmax(unit = "degF")=37 "Temperature difference at max. heat flux";
//----------------------------------------------------
//Variable Section
Real Pr(unit = "psia") "Reduced Pressure";
Real q_by_A_max(unit = "Btu/(hr.ft2)") "Maximum Heat Flux per unit area";
Real h_max(unit = "Btu/(hr.ft2.degF)") "Heat Transfer Coefficient";
//----------------------------------------------------
//Equation Section
equation
Pr = P/Pc ;
q_by_A_max = q_by_A_max_by_Pc * Pc ;
//By eqn 13.154
h_max = q_by_A_max / del_T_qmax ;
 
end Ex13_16;