//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.3 Page 253
//Title: Equivalent Diameter
//--------------------------------------------------
model Ex13_3
//--------------------------------------------------
//Parameter Section
parameter Real H(unit = "ft")=3 "Height of the Rectangular Duct";
parameter Real W(unit = "ft")=5 "Width of the Rectangular Duct";
//--------------------------------------------------
//Variable Section
Real S1(unit = "ft^2") "Cross-sectional Area of the Duct";
Real b(unit = "ft") "Wetted Perimeter";
Real Deq(unit = "ft") "Equivalent Diameter";
//--------------------------------------------------
//Equation Section
equation
S1 = H * W;
b = 2 * (H+W);
Deq = (4 * S1)/b;

end Ex13_3;