//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.4 Page 256
//Title: Boundary Layer Thickness & Stress
//--------------------------------------------------
model Ex13_4
//--------------------------------------------------
//Parameter Section
parameter Real y(unit = "m")=1.5 "Length of Flat Plate";
parameter Real vfs(unit = "m/s")=12 "Velocity of air over plate";
parameter Real rho(unit = "kg/(m^3)")=1.2 "Density of air";
parameter Real mu(unit = "(N.s)/(m^2)")=1.8e-5 "Viscosity of air";
//--------------------------------------------------
//Variable Section
Real NRey(unit = "NULL") "Reynolds Number";
Real yc(unit = "m") "Transition Point";
Real delta(unit = "m") "Boundary Layer Thickness";
Real NRedelta(unit = "NULL") "Reynolds Number in Turbulent Regime";
Real tauy(unit = "N/(m^2)") "Point Stress in Turbulent Regime";
Real tauynet(unit = "N/(m^2)") "Net Mean Stress over the Plate";
//--------------------------------------------------
//Equation Section
equation
//To test for flow regime
NRey = (y * vfs * rho)/mu;
//Turbulent Regime beyond some point yc is seen
yc = ((10^5) * mu)/(vfs * rho);
delta = (0.376 * y)/(NRey^0.2);
NRedelta = (delta * vfs * rho)/mu;
tauy = (0.0228 * rho * (vfs^2))/(NRedelta^0.25);
tauynet = rho * (vfs^2) * ((0.037/(NRey^0.2))-((0.0017 * yc)/y));

end Ex13_4;