//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.7 Page 264
//Title: Heat Transfer Coefficient & Heat Flux
//--------------------------------------------------
model Ex13_7
//--------------------------------------------------
//Parameter Section
//SAE 10 Oil Flows through Heat Exchanger
parameter Real D(unit = "ft")=2/12 "Inside Diameter of Tube";
parameter Real Q(unit= "gal/min")=400 "Flow Rate of Oil";
parameter Real Tbar(unit = "degF")=120 "Mean Oil Temperature";
parameter Real Twa(unit = "degF")=50 "Tube Wall Temperature-a";
parameter Real Twb(unit = "degF")=170 "Tube Wall Temperature-b";
//Data at 120 degF
parameter Real rho(unit = "lb/(ft^3)")=56.2 "Density of Oil";
parameter Real cP(unit = "Btu/(lb.degF)")=0.465 "Specific Heat Capacity of Oil";
parameter Real k(unit = "Btu/(hr.(ft^2).(degF/ft))")=0.07 "Thermal Conductivity of Oil";
parameter Real mu(unit = "centipoise")=20 "Viscosity of Oil at 120 degF";
//Viscosity at the tube wall temperatures
parameter Real mu1a(unit = "centipoise")=100 "Viscosity of Oil at 50 degF";
parameter Real mu1b(unit = "centipoise")=6 "Viscosity of Oil at 170 degF";
//--------------------------------------------------
//Variable Section
Real vbar(unit = "ft/s") "Velocity of Oil";
Real NRe(unit = "NULL") "Reynolds Number";
Real ha(unit = "Btu/(hr.degF.(ft^2))") "Heat Transfer Coefficient at Tw=50 degF";
Real hb(unit = "Btu/(hr.degF.(ft^2))") "Heat Transfer Coefficient at Tw=170 degF";
Real qbyA1(unit = "Btu/(hr.(ft^2))") "Heat Flux at Tw=50 degF";
Real qbyA2(unit = "Btu/(hr.(ft^2))") "Heat Flux at Tw=170 degF";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation 
vbar = (Q/(7.42*60))/(pi * (D^2)/4);
NRe = (D * vbar * rho)/(mu * 6.72e-4);
//If Oil is Cooling, as per Eq 13.64
ha = 0.023 * (k/D) * (NRe^0.8) * ((cP * mu* 2.42/k)^0.33) * ((mu/mu1a)^0.14);
qbyA1 = -ha * (Twa - Tbar);

//If oil is heating, as per Eq 13.65
hb = 0.023 * (k/D) * (NRe^0.8) * ((cP * mu* 2.42/k)^0.33) * ((mu/mu1b)^0.14);
qbyA2 = -hb * (Twb - Tbar);

end Ex13_7;