//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.9 Page 275
//Title: Nusselt Number of substances
//----------------------------------------------------
model Ex13_9
//----------------------------------------------------
//Parameter Section
parameter Real NRe(unit = "NULL")=100000 "Reynolds Number";
parameter Real f(unit = "NULL")=0.0184;
//(1) Air,(2) Water,(3) SAE 10 Lube oil,(4)Liquid Mercury
//At 100 degF, 1 atm
parameter Real[4] mu(each unit = "cP")={0.018,0.69,31,1.45} "Viscosity";
parameter Real[4] k(each unit = "Btu/(hr.ft.degF)")={0.0157,0.365,0.071,5.1} "Thermal Conductivity";
parameter Real[4] rho(each unit = "lb/ft3")={0,61.9,56.6,84.3} "Density";
parameter Real[4] cp(each unit = "Btu/(lb.degF)")={0.2401,1,0.45,0.33} "Specific Heat Capacity";
parameter Real[4] NPr(each unit = "NULL")={0.71,4.57,47.5,0.0234} "Prandtl Number";
//At 150 degF
parameter Real[4] mu_150(each unit = "cP")={0.02,0.42,12,1.4} "Viscosity";
//From Figure 13.6a, by Martinelli Analogy
parameter Real[4] Nu_M(each unit = "NULL")={170,400,800,20} "Nusselt Number";
//----------------------------------------------------
//Variable Section
Real[12] Nu(each unit = "NULL") "Nusselt numbers based on analogies";
//----------------------------------------------------
//Library Section
extends Modelica.Math;
//----------------------------------------------------
//Equation Section
equation
//Solution for Air
Nu[1] = 0.023 * (NRe^0.8) * (NPr[1] ^ (1/3)) * ((mu[1]/mu_150[1]) ^ 0.14) "Air-Empirical-Eq 13.65";
Nu[2] = NRe * NPr[1] * (f/8) "Air-Reynolds";
Nu[3] = NRe * (NPr[1] ^ (1/3)) * (f/8) * ((mu[1]/mu_150[1]) ^ 0.14) "Air-Colburn";
//Solution for Liquid Mercury
Nu[4] = 0.625 * (NRe * NPr[4]) ^ 0.4 "Hg-Empirical-Eq 13.97";
Nu[5] = NRe * NPr[4] * (f/8) "Hg-Reynolds";
Nu[6] = NRe * (NPr[4] ^ (1/3)) * (f/8) * ((mu[4]/mu_150[4]) ^ 0.14) "Hg-Colburn";
//Solution for Water
Nu[7] = 0.023 * (NRe^0.8) * (NPr[2] ^ (1/3)) * ((mu[2]/mu_150[2]) ^ 0.14) "Water-Empirical-Eq 13.65";
Nu[8] = NRe * NPr[2] * (f/8) "Water-Reynolds";
Nu[9] = NRe * (NPr[2] ^ (1/3)) * (f/8) * ((mu[2]/mu_150[2]) ^ 0.14) "Water-Colburn";
//Solution for SAE 10 oil
Nu[10] = 0.023 * (NRe^0.8) * (NPr[3] ^ (1/3)) * ((mu[3]/mu_150[3]) ^ 0.14) "Oil-Empirical-Eq 13.65";
Nu[11] = NRe * NPr[3] * (f/8) "Oil-Reynolds";
Nu[12] =  NRe * (NPr[3] ^ (1/3)) * (f/8) * ((mu[3]/mu_150[3]) ^ 0.14) "Oil-Colburn";

end Ex13_9;