//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 15: Heat Transfer
//Example 15.4 Page 343
//Title: Shell&Tube Heat Exchanger: Mean Temperature Difference
//--------------------------------------------------
model Ex15_4
//--------------------------------------------------
//Parameter Section
parameter Real T_a1(unit = "degF")=400 "Temperature at shell side entrance";
parameter Real T_a2(unit = "degF")=200 "Temperature at shell side exit";
parameter Real T_b1(unit = "degF")=100 "Temperature at tube side entrance";
parameter Real T_b2(unit = "degF")=200 "Temperature at tube side exit";
//From figure 15.14b, for X=0.33 & Z=2,
parameter Real Y(unit = "")=0.96 "Correction factor";
//--------------------------------------------------
//Variable Section
Real del_T1(unit = "degF") "Temperature Difference at shell side";
Real del_T2(unit = "degF") "Temperature Difference at tube side";
Real del_T_lm(unit = "degF") "Log Mean Temperature Difference";
Real del_T_lmC(unit = "degF") "Log Mean Temperature Difference:Corrected";
//--------------------------------------------------
//Libraries Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation 
del_T1 = T_a1 - T_a2 ;
del_T2 = T_b2 - T_b1 ;
del_T_lm = (del_T1 - del_T2)/log(del_T1/del_T2) ;
del_T_lmC = Y * del_T_lm ;

end Ex15_4;