//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 15: Heat Transfer
//Example 15.9 Page 377
//Title: Heat Transfer by Radiation
//--------------------------------------------------
model Ex15_9
//--------------------------------------------------
//Parameter Section
parameter Real epsilon1(unit = "")=0.5 "Emissivity of Stock";
parameter Real epsilon2(unit = "")=0.9 "Emissivity of Glow bar";
//Centre-to-Centre Distance between glow bars = Unit length of bed
parameter Real B(unit = "ft")=4/12 "Bed length";
parameter Real D(unit = "ft")=1/12 "Diameter of glow bar";
parameter Real T1(unit = "degR")=200+459.67 "Temperature of stock";
parameter Real T2(unit = "degR")=2800+459.67 "Temperature of glow bar";
parameter Real sigma(unit = "Btu/(hr.ft2.degR)")=0.173e-8 "Stefan-Boltzmann Constant";
//From figure 15.35
parameter Real F12(unit = "")=0.6 "View factor";
//--------------------------------------------------
//Variable Section
Real F_1to2(unit = "") "Fraction of radiation";
Real q_r(unit = "Btu/(hr.ft2)") "Rate of Heat Transfer";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation 
//Fraction of radiation from stock surface to dryer wall
F_1to2 = 1/((1/F12) + ((1/epsilon1)-1) + ((B/(pi*D))*((1/epsilon2)-1))) ;
//Assuming unit area of bed,By eqn 15.111
q_r = 1 * F_1to2 * sigma * ((T1^4)-(T2^4)) ;

end Ex15_9;