//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 17: Simultaneous Heat and Mass Transfer-Humidification
//Example 17.1 Page 436
//Title: Drying of air
//--------------------------------------------------
model Ex17_1
//--------------------------------------------------
//Parameter Section
parameter Real RH(unit = "NULL")=0.5 "Relative Humidity-50%";
//At 70 degF, from humidity chart in Appendix D-14
parameter Real Ys(unit = "NULL")=0.0262 "Humidity of ambient air";
//--------------------------------------------------
//Variable Section
Real Pa(unit = "atm") "Vapour Pr. of moisture in air";
Real p_a(unit = "atm") "Partial Pr. of moisture in air";
Real S(unit = "%") "Perecntage Saturation";
//--------------------------------------------------
//Equation Section
equation
Ys = Pa/(1-Pa) ;
p_a = RH * Pa ;
S = ((p_a /(1-p_a)) / (Pa/(1-Pa))) * 100 ;

end Ex17_1;