//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 18: Simultaneous Heat and Mass Transfer-Drying
//Example 18.1 Page 466
//Title: Drying time for raw cotton in Batch tray drier
//--------------------------------------------------
model Ex18_1
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "g/(cm^3)")=0.7 "Density of raw cotton";
parameter Real Tv(unit = "degC")=75 "Temperature of Saturated Air";
parameter Real Ti(unit = "degC")=50 "Initial Stock Temperature=Wet bulb temperature of Air";
parameter Real A(unit = "(cm^2)")=3600 "Area of each Tray";
parameter Real d(unit = "cm")=1 "Thickness of each tray";
parameter Real Gv_SI(unit = "kg/(hr. (m^2))")=2500 "mass flow rate of cotton";
parameter Real X0(unit = "g of water/g of dry dolids")=1 "Initial Moisture Content";
parameter Real Xf(unit = "g of water/g of dry dolids")=0.1 "Final Moisture Content";
parameter Real Xc(unit = "g of water/g of dry dolids")=0.4 "Critical moisture content";
parameter Real lambda(unit = "J/kg")=2.383e+06;
//From Fig. 18.11
parameter Real Y(unit = "mol of water/mol of dry air")=0.122 "Mole ratio of moisture in actual air";
parameter Real h(unit = "NULL")=0.2 "Humidity for the given condition";
parameter Real XE(unit = "g of water/g of dry dolids")=0.052 "Equilibrium moisture content";
//--------------------------------------------------
//Variable Section
Real y(unit = "NULL") "Mole fraction of moisture in actual air";
Real ys(unit = "NULL") "mole fraction of moisture in saturated air";
Real Ys(unit = "mol of water/mol of dry air") "Mole ratio of moisture in saturated air";
Real RH(unit = "%") "Relative Humidity";
Real hv(unit = "W/(m^2).K") "heat transfer coefficient for drying";
Real Rc(unit = "kg/(hr. (m^2))") "Resistance";
Real Ws(unit = "kg") "Total weight of dry solids";
Real td_c(unit = "hr") "Drying time during the constant rate period";
Real td_f(unit = "hr") "Drying time during the falling rate period";
Real td(unit = "hr") "Total drying time";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
Ys = Y/h;
y = Y/(1+Y);
ys = Ys/(1+Ys);
RH = y/ys;
hv = ((Gv_SI * 2.2/10.8)^0.8) * (0.0128/0.17613);
Rc = (hv * 3600 / lambda) * (Tv - Ti);
Ws = A*d*rho/1000;
td_c = (Ws * (X0 - Xc))/(Rc * (A/10000));
td_f = ((-Ws * (Xc - XE))/(Rc * (A/10000))) * log((Xf-XE)/(Xc-XE));
td = td_c + td_f;

end Ex18_1;