//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 19:Simultaneous Heat and Mass Transfer-Evaporation & Crystallization
//Example 19.5 Page 523
//Title: Krystal crystalizer-CaCl2.4H2O
//--------------------------------------------------
model Ex19_5
//--------------------------------------------------
//Parameter Section
parameter Real w(unit = "wt%")=40 "% of CaCl2 in feed";
parameter Real HF(unit ="Btu/lb.solution")=(-8) "Feed enthalpy (fig.19.29)";
//From Fig.19.32,
parameter Real xL(unit = "")=58.5 "Amount of water present";
parameter Real xC(unit = "")=61 "Amount of CaCl2.4H2O crystals present";
parameter Real xS(unit = "")=52 "Amount of CaCl2 present";
//--------------------------------------------------
//Variable Section
Real FH_min(unit = "Btu/lb") "Minimum Feed heating required";
Real FH_max(unit = "Btu/lb") "Maximum Feed heating required";
Real FH(unit = "Btu/lb") "Feed heating required";
Real Mv(unit = "lb/lb.feed") "Mass of Vapour Generated";
Real Mc(unit = "lb/lb.feed") "Mass of Crystals obtained";
Real Y(unit = "lb.CaCl2 crystals/lb.CaCl2 fed") "Yield of CaCl2";
//--------------------------------------------------
//Equation Section
equation
//From Fig.19.32
FH_min = 185 - HF;
FH_max = 305 - HF;
FH = 270 - HF;
Mv = (xL-w)/xL;
Mc = (1-Mv) * (xL-xS) / (xC-xS);
Y = (Mc * (111/183)) / (w/100) ;

end Ex19_5;