//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.6 Page 562
//Title: Manometer Reading for Lube oil
//--------------------------------------------------
model Ex20_6
//--------------------------------------------------
//Parameter Section
parameter Real d(unit = "ft")=3.5/12 "Orifice diameter";
parameter Real D(unit = "ft")=5.047/12 "Diameter of 5-in sch-40 pipe";
parameter Real mu(unit = "lb/(ft.s)")=15*6.72e-4 "Viscosity of oil";
parameter Real rho(unit = "lb/ft3")=0.87*62.3 "Density of oil";
parameter Real rho_m(unit = "lb/ft3")=13.6*62.3 "Density of mercury";
parameter Real Q(unit = "gal/min")=300 "Fow rate of oil";
//From fig.20.11,
parameter Real C0(unit = "")=0.635 "Orifice Coefficient";
//--------------------------------------------------
//Variable Section
Real Ao(unit = "ft2") "Area of orifice";
Real Ap(unit = "ft2") "Area of pipe";
Real v_o(unit = "ft/s") "Linear velocity through orifice";
Real NRe_o(unit = "") "Orifice Reynolds no.";
Real v_1(unit = "ft/s") "Velocity in pipe";
Real del_P(unit = "lbf/ft2") "Pressure drop in pipe";
Real R(unit = "ft") "Probable manometer reading";
Real R_act(unit = "in") "Reading along slope of Manometer";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
Ao = pi*(d^2)/4 ; 
Ap = pi*(D^2)/4 ; 
v_o = (Q*0.1338)/(Ao*60) ;
NRe_o = d*v_o*rho/mu;
v_1 = v_o * Ao/Ap;
//From eqn 20.46
del_P = (rho * (v_1^2) *(((Ap/Ao)^2)-1)) / ((C0^2)*2*32.2) ;
//From eqn 20.36
R = del_P/(rho_m - rho) ;
//Since the manometer leg is inclined at 30 degrees
R_act = 2*R*12 ;

end Ex20_6;