//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 21: Fluid Motive Devices
//Example 21.3 Page 592
//Title: Pump type & Specific speed
//--------------------------------------------------
model Ex21_3
//--------------------------------------------------
//Parameter Section
parameter Real n(unit = "rpm")=1800 "Assumed Operating Speed";
parameter Real Q(unit = "gal/min")=2500 "Liquid flow rate";
parameter Real H(unit = "ft")=50 "Head of liquid";
//--------------------------------------------------
//Variable Section
Real Ns(unit = "rpm") "Specific speed of pump";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//High Q & high H would require Centrifugal Pump
//By Eqn 21.8
Ns = (n * sqrt(Q))/(H^0.75) ;
//From Ns value & Figure 21.10, mixed flow centrifugal pump is suggested

end Ex21_3;