//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.10 Page 649
//Title: Synthetic Detergent Manufacture
//--------------------------------------------------
model Ex22_10
//--------------------------------------------------
//Parameter Section
parameter Real Dp(unit = "ft")=(0.6/(25.4*12)) "Particle Diameter";
parameter Real Lv(unit = "ft")=60 "Length of conveyor:Vertical section";
parameter Real Lh(unit = "ft")=30 "Length of conveyor:Horizontal section";
parameter Real G(unit = "lb/hr")=3000 "Product Rate";
parameter Real d(unit = "ft")=10/12 "Tube diameter";
parameter Real Q(unit = "scfm")=500 "Air flow rate";
//Bulk mean density of solid is given as 20 lb/ft3
parameter Real rho_s(unit = "lb/ft3")=20/(1-0.38) "Density of Solid";
parameter Real rho(unit = "lb/ft3")=(29*492)/(359*540) "Density of air";
parameter Real mu(unit = "lb/(ft.s)")=0.02*6.72e-4 "Viscosity of air";
//From Appendix C-3
parameter Real f(unit = "")=0.019 "Friction factor at wall";
//--------------------------------------------------
//Variable Section
Real vs(unit = "ft/s") "Superficial Solid velocity";
Real v(unit = "ft/s") "Gas velocity";
Real vt(unit = "ft/s") "Terminal velocity";
Real ec(unit = "") "Critical Porosity";
Real LHS(unit = "") "LHS of eqn 22.95b";
Real RHS(unit = "") "RHS of eqn 22.95b";
Real vs_a(unit = "ft/s") "Actual Solids velocity";
Real e_sub(unit = "") "(1-epsilon) term";
Real fs(unit = "") "Friction factor";
Real NRe(unit = "") "Reynolds No.";
Real Wall_Fr(unit = "") "Wall Friction term=4T/D";
Real del_Pv(unit = "lb/ft2") "Pr. drop for vertical section";
Real del_Ph(unit = "lb/ft2") "Pr. drop for horizontal section";
Real del_Pb(unit = "lb/ft2") "Pr. drop at bend";
Real del_P(unit = "psi") "Total Pr. Drop";
Real P_B(unit = "psi") "Pr. at Blower inlet";
//--------------------------------------------------
//Library Section
extends  Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
vs = (G/(rho_s*3600)) / (pi*(d^2)/4) ;
v = (Q/60) * (540/492) / (pi*(d^2)/4) ;
//From the value 4334 of the term (4/3)*(g*Dp^3/mu^2)*rho*del_rho
//By figure 22.1
vt = 55*mu/(Dp*rho) ;
//By eqn 22.95a
vs = ((v*ec)-vt)*(1-ec) ;
//Eqn 22.95b: To check whether there is dilute flow
LHS = ((v*ec)-vt)^2 ;
RHS = 100*((ec^(-0.47))-1) ;
//LHS not = RHS --> Dilute Flow
vs_a = (-vt) + v;
e_sub = vs/vs_a;
//Eqn 22.101
fs = e_sub * 0.05/vs ;
NRe = (d*v*rho)/mu ;
//Eqn 22.100
Wall_Fr = (f*(v^2)/(2*32.2*d)) + (2*fs*rho_s*d*(vs^2)/e_sub) ;
//Eqn 22.99 
//For vertical section
del_Pv = (rho_s*(vs^2)/e_sub) + (e_sub*32.2*rho_s*Lv) + (Wall_Fr * Lv) ;
//For Horizontal Section
//2nd term in 22.99 is for solids lifted and hence neglected here
del_Ph = (rho_s*(vs^2)/e_sub) + (Wall_Fr * Lh) ;
//For Bend
del_Pb = ((rho_s*e_sub) + (rho*(e_sub-1))) * ((v^2)/(2*32.2));
del_P  = (del_Pv + del_Ph + del_Pb) / 144;
//Pressure at blower inlet
P_B = 14.7 - del_P ;

end Ex22_10;