//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.12 Page 657
//Title: Maximum Flow Rate in Open Sand Filter
//--------------------------------------------------
model Ex22_12
//--------------------------------------------------
//Parameter Section
//mesh size -20 + 28 and sphericity = 0.9
parameter Real Dp(unit = "ft")=0.0021 "Mean Particle Diameter";
parameter Real L(unit = "ft")=3 "Length of bed";
parameter Real del_z(unit = "ft")=5 "Bed height+water level";
parameter Real rho(unit = "lb/ft3")=62.4 "Water Density";
parameter Real mu(unit = "lb/(ft.s)")=1*6.72e-4 "Water Viscosity";
//From Appendix B, fig B-10
parameter Real e(unit = "")=0.4 "Porosity";
//--------------------------------------------------
//Variable Section
Real del_P(unit = "lb/ft2") "Pr. drop";
Real vs(unit = "ft/s") "Superficial Velocity";
Real NRe(unit = "") "Reynolds NO.";
Real vsm_c(unit = "ft/s") "Corrected velocity";
Real Q(unit = "gal/(ft2.min)") "Maximum flow rate";
//--------------------------------------------------
//Equation Section
equation
//Since g/gc = 1
del_P = del_z * rho *1;
//By Carman-Kozeny equation 22.76
(del_P/L)*32.2 = 180 * (((1-e)^2)/(e^3)) * (mu*vs/(Dp^2)) ;
//Eqn 22.76 holds at low NRe only
NRe = (Dp * vs * rho)/mu ;
//From fig22.30 the eqn is in error by a factor of sqrt(36.5/35) in terms of 1/(vsm^2)
vsm_c = vs * ((35/36.5)^0.5) ;

//Max. Flow Rate immediately after Backwashing
Q = vsm_c * 60 * 7.48;

end Ex22_12;