//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.13 Page 670
//Title: CaCO3 Precipitate in Water
//--------------------------------------------------
model Ex22_13
//--------------------------------------------------
//Parameter Section
parameter Real A(unit = "ft2")=0.283 "Plate area";
parameter Real del_P(unit = "lbf/ft2")=40*144 "Pressure drop";
parameter Real rho_dry(unit = "lb/ft3")=100 "Density of dry cake";
parameter Real rho_s(unit = "lb/ft3")=2.93*62.4 "Density of solid CaCO3";
parameter Real rho_w(unit = "lb/ft3")=62.4 "Density of water";
parameter Real mu_w(unit = "lb/(ft.s)")=1.1*6.72e-4 "Water viscosity";
parameter Real x(unit = "")=0.0723 "Wt. fraction of CaCO3";
parameter Real gc(unit = "ft/s2")=32.2 "Gravitaional acceleration";
//--------------------------------------------------
//Variable Section
Real w(unit = "lb.CaCO3/ft3.H2O") "w term in eqn 22.123a";
Real Ve(unit = "l") "Filtrate Volume equivalent in resistance";
Real s(unit = "s/ft6") "Slope term";
Real alpha(unit = "ft/lb") "Specific Cake Resistance";
Real e(unit = "") "Cake Porosity";
Real S0(unit = "ft2/ft3.solids") "Specific Cake Surface";
//--------------------------------------------------
//Library Section
extends  Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//From fig22.57 (plot of del_theta/del_V Vs V), slope=18.05 s/(l^2) and intercept=5.9 s/l
Ve = 5.9/18.05 ;
w = x/((1-x)/ rho_w) ;
s = 18.05/(0.0353^2) ;
//Eqn 22.123a
alpha = (s*gc*del_P*4*(A^2))/(mu_w * w) ;
e = 1 - (rho_dry/rho_s) ;
S0 = sqrt ((alpha * rho_s * (e^3))/(5*(1-e))) ;

end Ex22_13;