//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.14 Page 671
//Title: Slurry Volume and Filtration Time
//--------------------------------------------------
model Ex22_14
//--------------------------------------------------
//Parameter Section
parameter Real A(unit = "ft2")=9.4 "Effective plate area";
parameter Real s(unit = "ft")=2.5/12 "Thickness of each plate";
parameter Real N(unit = "")=20 "No. of plates";
parameter Real del_P(unit = "lbf/ft2")=40*144 "Pressure drop";
parameter Real rho_dry(unit = "lb/ft3")=100 "Density of dry cake";
parameter Real rho_s(unit = "lb/ft3")=2.93*62.4 "Density of solid CaCO3";
parameter Real rho_w(unit = "lb/ft3")=62.4 "Density of water";
parameter Real mu_w(unit = "lb/(ft.s)")=1.1*6.72e-4 "Water viscosity";
parameter Real x(unit = "")=0.0723 "Wt. fraction of CaCO3";
parameter Real gc(unit = "ft/s2")=32.2 "Gravitaional acceleration";
//From example 22.13
parameter Real w(unit = "lb.CaCO3/ft3.H2O")=4.86312 "w term in eqn 22.123a";
parameter Real Ve(unit = "l")=0.32687 "Filtrate Volume equivalent in resistance";
parameter Real alpha(unit = "ft/lb")=2.39421e+11 "Specific Cake Resistance";
parameter Real e(unit = "")=0.45305 "Cake Porosity";
//--------------------------------------------------
//Variable Section
Real LA(unit = "ft3") "Volume of frames";
Real S(unit = "lb") "Solids in cake"; 
Real Wt(unit = "lb") "Weight of slurry fed";
Real rho(unit ="lb/ft3") "Density of slurry";
Real Vs(unit = "gal") "Volume of Slurry";
Real V(unit = "ft3") "Volume of filtrate";
Real theta(unit = "hr") "Time for filtration";
//--------------------------------------------------
//Equation Section
equation
LA = (A/2) * s * N;
S = LA * rho_dry;
Wt = S/x ;
(1/rho) = ((1-x)/rho_w) + (x/rho_s) ;
Vs = (Wt/rho)*7.48 ;
//Eqn 22.117
LA * (1-e) * rho_s = w * (V + (e*LA)) ;
//Eqn 22.122a
theta = (mu_w * alpha * w/(3600*gc*del_P*((A*N)^2))) * (((V^2)/2) + (Ve*V)) ;

end Ex22_14;