//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.16 Page 679
//Title: CaCO3 slurry in Basket Centrifugal Filter
//--------------------------------------------------
model Ex22_16
//--------------------------------------------------
//Parameter Section
parameter Real rho_s(unit = "lb/ft3")=2.93*62.4 "Density of solid CaCO3";
parameter Real rho_w(unit = "lb/ft3")=62.4 "Density of water";
parameter Real mu_w(unit = "lb/(ft.s)")=1*6.72e-4 "Water viscosity";
parameter Real N(unit = "rpm")=1200 "Speed of centrifuge";
parameter Real h(unit = "ft")=10/12 "Height of Basket";
parameter Real r1(unit = "ft")=11/12 "Radius to the liquid surface over cake";
parameter Real r2(unit = "ft")=11/12 "Radius to the filter cake surface";
parameter Real r3(unit = "ft")=12/12 "Radius to the filter cloth surface";
//From example 22.13
parameter Real alpha(unit = "ft/lb")=2.39421e+11 "Specific Cake Resistance";
parameter Real e(unit = "")=0.45305 "Cake Porosity";
//--------------------------------------------------
//Variable Section
Real q(unit = "gal/min") "Filtration Rate";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//By Eqn 22.142, for negligible medium resistance,
//Filtration rate = dV/dtheta = q
q = ((pi^3)*(N^2)*rho_w*h*((r3^2)-(r1^2))*7.48*60) / (900*mu_w*alpha*rho_s*(1-e)*(log(r3/r2))) ;

end Ex22_16;