//Foust A. S.,Principles of Unit OPerations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 3: Phase Relations
//Example 3.2 Page 32
//Title: Relative Volatility
//------------------------------------
model Ex3_2
//------------------------------------
//Parameter Section
//At 40 degC
parameter Real Pb(unit = "kN/m^2")=373 "Vapour Pressure of Butane";
parameter Real Pp(unit = "kN/m^2")=117 "Vapour Pressure of Pentane";
//At 465 psia
parameter Real Kb(unit = "NULL")=0.27 "Equilibrium Constant for Butane";
parameter Real Kp(unit = "NULL")=0.10 "Equilibrium Constant for Pentane";
//------------------------------------
//Variable  Section
Real alphabp1(unit = "NULL") "Relative Volatility of Butane to pentane (Raoult's Law)";
Real alphabp2(unit = "NULL") "Relative Volatility of Butane to pentane (Equilibrium Constant)";
//------------------------------------
//Equation Section
equation
alphabp1 = Pb/Pp; //Assuming Raoult's Law Holds Good
alphabp2 = Kb/Kp; //For systems deviating from Raoult's Law

end Ex3_2;