//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 4: Equilibrium Stage Calculations
//Example 4.1 Page 49
//Title: Equimolar Liquid Mixture
//------------------------------------
model Ex4_1
//------------------------------------
//Parameter Section
parameter Real P(unit = "psia")=30 "Total Pressure";
parameter Real F(unit = "lb moles")=100 "Basis (Feed)";
parameter Real xf(unit = "NULL")=0.5 "Mole fraction of Benzene in feed";
//At 250 degF (From Appendix D-1)
parameter Real Pb(unit = "psia")=43 "Vapour Pressure of Benzene";
parameter Real Pt(unit = "psia")=20 "Vapour Pressure of Toluene";
//------------------------------------
//Variable  Section
Real xb(unit = "NULL") "Mole fraction of Benzene in liquid phase";
Real xt(unit = "NULL") "Mole fraction of Toluene in liquid phase";
Real yb(unit = "NULL") "Mole fraction of Benzene in vapour phase";
Real yt(unit = "NULL") "Mole fraction of Toluene in vapour phase";
Real L(unit = "lb moles") "Liquid Fraction";
Real V(unit = "lb moles") "Vapour Fraction";
//------------------------------------
//Equation Section
equation
//Equilibrium
xb + xt = 1;
yb + yt = 1;
// Raoult's Law
yb = (Pb/P) * xb; 
yt = (Pt/P) * xt;
//Mass Balances
F = L + V;
(F * xf) = (L * xb) + (V * yb);

end Ex4_1;