//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 4: Equilibrium Stage Calculations
//Example 4.2 Page 49
//Title: Equilibrium Stage Compositions
//------------------------------------
model Ex4_2
//------------------------------------
//Parameter Section
parameter Real F(unit = "kg")=300 "Total (feed)";
parameter Real L(unit = "kg")=200 "Liquid Phase";
parameter Real V(unit = "kg")=100 "Vapour Phase";
parameter Real xa0(unit = "NULL")=0.5 "Mole fraction of Acetic Acid in fed liquid";
parameter Real ya0(unit = "NULL")=0.15 "Mole fraction of Acetic Acid in fed vapour";
parameter Real xb0(unit = "NULL")=0.4 "Mole fraction of water in fed liquid";
parameter Real yb0(unit = "NULL")=0.03 "Mole fraction of water in fed vapour";
parameter Real xc0(unit = "NULL")=0.1 "Mole fraction of Iso propyl Alcohol in fed liquid";
parameter Real yc0(unit = "NULL")=0.82 "Mole fraction of Iso propyl Alcohol in fed vapour";

//From Figure 4.2 Page 50
parameter Real xaf(unit = "NULL")=0.45 "Mole fraction of Acetic Acid in leaving liquid";
parameter Real yaf(unit = "NULL")=0.32 "Mole fraction of Acetic Acid in leaving vapour";
parameter Real xbf(unit = "NULL")=0.45 "Mole fraction of water in leaving liquid";
parameter Real ybf(unit = "NULL")=0.11 "Mole fraction of water in leaving vapour";
parameter Real xcf(unit = "NULL")=0.1 "Mole fraction of Iso propyl Alcohol in leaving liquid";
parameter Real ycf(unit = "NULL")=0.57 "Mole fraction of Iso propyl Alcohol in leaving vapour";
//------------------------------------
//Variable  Section
Real L1(unit = "kg") "Liquid Phase (leaving)";
Real V1(unit = "kg") "Vapour Phase (leaving)";
Real za(unit = "NULL") "Total Feed Composition of Acetic Acid"; 
Real zb(unit = "NULL") "Total Feed Composition of Water"; 
Real zc(unit = "NULL") "Total Feed Composition of Iso Propyl Alcohol"; 
//------------------------------------
//Equation Section
equation
//Equilibrium
za + zb + zc = 1;
za = ((L * xa0) + (V * ya0))/F ;
zc = ((L * xc0) + (V * yc0))/F ;
//Mass Balance
F = L1 + V1;
(F * za) = (L1 * xaf) + (V1 * yaf) ;

end Ex4_2;