//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 4: Equilibrium Stage Calculations
//Example 4.4 Page 53
//Title: Vapourization of Saturated Liquid
//------------------------------------
package Ex4_4
//------------------------------------
model Ex4_4_a
//------------------------------------
//Parameter Section
parameter Real za(unit = "NULL")=0.5 "Total Feed Composition of Ethanol";
//From Figure 4.6 Page 53
parameter Real xaf(unit = "NULL")=0.265 "Mole fraction of Ethanol in remaining liquid";
parameter Real yaf(unit = "NULL")=0.565 "Mole fraction of Ethanol in vapour";
//------------------------------------
//Variable Section
Real V(unit = "mole%") "Percentage of Liquid Vapourized";
//------------------------------------
//Equation Section
equation
V = (xaf - za)/(xaf - yaf) ;

end Ex4_4_a;
//------------------------------------
model Ex4_4_b
//------------------------------------
//Parameter Section
//Basis: 1 lb mole of original liquid
//From Figure 4.6 Page 53
parameter Real hF(unit = "BTU/lb mole")=3500 "Final Enthalpy after heat is added";
parameter Real hF1(unit = "BTU/lb mole")=17000 "Enthalpy of Mixture before heat is added";
//------------------------------------
//Variable Section
Real Q(unit = "BTU/lb mole") "Heat added for the reverse process";
//------------------------------------
//Equation Section
equation
Q = hF - hF1 ;

end Ex4_4_b;
//------------------------------------

end Ex4_4;