//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 5: Countercurrent Multistage Operations
//Example 5.2 Page 65
//Title: Solute Recovery
//------------------------------------
model Ex5_2
//------------------------------------
//Parameter Section
parameter Real ma(unit = "kg/hr")=2000 "Mass Flow Rate of Acetic Acid";
parameter Real xa(unit = "NULL")=0.4 "Solute Concentration in Feed";
//From Figure5.6
parameter Real y1a(unit = "NULL")=0.148 "Solute Concentration in Extract";
//------------------------------------
//Variable Section
Real V1(unit = "kg/hr") "Mass Flow Rate of Exiting Vapour";
Real R(unit = "%") "Solute Recovery";
//------------------------------------
//Equation Section
equation
//From Figure 5.6, By Inverse Lever-arm Rule
V1 = 6000 * ((0.667-0)/(0.795-0));
R = (V1 * y1a * 100)/(ma * xa);

end Ex5_2;