//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 7: Simplified Calculation Methods
//Example 7.4 Page 111
//Title: Initial & Final Reflux Ratio
//--------------------------------------------
model Ex7_4
//--------------------------------------------
//Parameter Section
parameter Real F(unit = "lb moles")=100 "Total Feed (Basis)";
parameter Real xFB(unit = "NULL")=0.35 "Benzene Composition in Feed";
parameter Real xFT(unit = "NULL")=0.65 "Toluene Composition in Feed";
parameter Real d(unit = "NULL")=0.6 "Percentage of Benzene Recovered in Distillate";
parameter Real xD(unit = "NULL")=0.95  "Benzene Composition in Distillate";

parameter Real Bf(unit = "lb moles")=14 "Final still-pot composition of Benzene";
parameter Real Tf(unit = "lb moles")=63.9 "Final still-pot composition of Toluene";
//From Figure 7.13 Pg 111
parameter Real mi(unit = "NULL")=0.8 "Slope for Initial Reflux Ratio";
//From Figure 7.13 Pg 111
parameter Real mf(unit = "NULL")=76/77 "Slope for Final Reflux Ratio";
//--------------------------------------------
//Variable Section
Real Ri(unit = "NULL") "Initial Reflux Ratio";
Real Bd(unit = "lb moles") "Benzene Recovereed in Distillate";
Real Td(unit = "lb moles") "Toluene in Distillate"; 
Real xBf(unit = "NULL");
Real Rf(unit = "NULL") "Initial Reflux Ratio";
//--------------------------------------------
//Equation Section
equation
Ri = mi/(1-mi);
Bd = d * xFB;
Td = (1-xD)*(Bd)/(xD);
xBf = Bf/(Bf + Tf);
Rf = mf/(1-mf);

end Ex7_4;