//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.14 Page 182
//Title: Thermal Conductivity of liquid water at 20 degC
//------------------------------------------------------
model Ex9_14
//------------------------------------------------------
//Parameter Section
parameter Real rho(unit = "kg/(m^3)")=998 "Density of Water";
parameter Real M(unit = "kg/mol")=18e-3 "Molecular mass of water"; 
parameter Real cp(unit = "J/(kg.degC)")=4.18e+3 "Specific Heat Capacity of water";
//------------------------------------------------------
//Variable Section
Real k(unit = "J/(s.m.degC)") "Thermal Conductivity of water";
//------------------------------------------------------
//Equation Section
equation
//From equation 9.61
k = 3.59e-9 * cp * rho * ((rho/M)^(1/3)) ;

end Ex9_14;