//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.7 Page 177
//Title: Carbon-di-oxide:Thermal COnductivity
//--------------------------------------------
model Ex9_7
//--------------------------------------------
//Parameter Section
parameter Real M(unit = "kg/mol")=44e-3 "Molecular Weight of Carbon Dioxide";
parameter Real T(unit = "K")=373 "Temperature 100 degC";
parameter Real sigma(unit = "m")=3.996e-10 "Molecular Diameter";
//From Appendix D-6a, D-6b
parameter Real Omega(unit = "NULL")=1.138 "Collision Integral";
//From Appendix D-13
parameter Real cv(unit = "J/(mol.K)")=40.5 "Molar Heat Capacity at Constant Volume";
//--------------------------------------------
//Variable Section
Real k(unit = "J/(s.(m^2))(degC/m)") "Thermal Conductivity of Carbon Dioxide at 0 degC and 1 atm";
//--------------------------------------------
//Library section
extends Modelica.Constants;
extends Modelica.Blocks.Math;
//--------------------------------------------
//Equation Section
equation
k  = ((2.63e-23 * sqrt(T/M))/((sigma^2) * Omega))*(((4/15) * (cv/R)) + (3/5)) ;

end Ex9_7;