//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.9 Page 178
//Title: Mixture Diffusivity
//--------------------------------------------
model Ex9_9
//--------------------------------------------
//Parameter Section
parameter Real T(unit = "K")=298 "Temperature 25 degC";
parameter Real Ma(unit = "kg/mol")=44e-3 "Molecular Weight of Carbon Dioxide";
parameter Real Mb(unit = "kg/mol")=28e-3 "Molecular Weight of Nitrogen";
parameter Real epsilonka(unit = "K")=190 "(epsilon/k) value of Carbon Dioxide"; 
parameter Real epsilonkb(unit = "K")=79.8 "(epsilon/k) value of Nitrogen"; 
parameter Real sigmaa(unit = "m")=3.996e-10 "Molecular Diameter of Carbon Dioxide";
parameter Real sigmab(unit = "m")=3.749e-10 "Molecular Diameter of Nitrogen";
parameter Real P(unit  = "N/(m^2)")=1.013e+5 "Atmospheric pressure";
//From Appendix D-6a, D-6b
parameter Real Omega(unit = "NULL")=1.010 "Collision Integral";
//--------------------------------------------
//Variable Section
Real sigmaab(unit = "m") "Equivalent Molecular Diameter";
Real epsilonkab(unit = "K") "Equivalent (epsilon/k)";
Real D(unit = "(m^2)/s")"Mass Diffusivity of Mixture at 25 degC and 1 atm";
//------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//--------------------------------------------
//Equation Section
equation
sigmaab = (sigmaa + sigmab)/2;
epsilonkab = sqrt(epsilonka * epsilonkb);
D = (8.42e-24 * sqrt((T^3)*((1/Ma)+(1/Mb))/2))/(P * (sigmaab^2) * Omega);

end Ex9_9;