  //Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
  //Chapter 10:Differential Mass, Heat and Momentum Balances
  //Example 10.7 Page 207
  //Title: Electrical Resistance Wire
  //--------------------------------------------------
 model Ex10_7
  //--------------------------------------------------
  //Parameter Section
  parameter Real d(unit = "ft") = 0.25 / 12 "Diameter of wire";
  parameter Real L(unit = "ft") = 10 "Length of wire";
  parameter Real q(unit = "Btu/hr") = 1400000 "Heat Flux";
  parameter Real T1(unit = "degF") = 1500 "Surface temperature of wire";
  parameter Real k(unit = "Btu/(hr.(ft2).(degF/ft))") = 10 "Thermal Conductivity of wire";
  parameter Real T(unit = "degF") = 2500 "Meting point of wire";
  //--------------------------------------------------
  //Variable Section
  Real r1(unit = "ft") "Radius of wire";
  Real A(unit = "ft2") "Area";
  Real Gq(unit = "Btu/(hr.ft3") "Rate of Internal heat generation";
  Real T0(unit = "degF") "Temperature of the core";
  Real x(unit = "NULL") "LHS of eqn 10.107";
  Real X(unit = "NULL") "LHS of eqn 10.107";
  Real r(unit = "in") "Radius of molten core formed";
  //--------------------------------------------------
  //Library section
  extends Modelica.Constants;
  extends Modelica.Math;
  //--------------------------------------------------
  //Equation Section
  equation
  r1 = d / 2;
  A = pi * r1 ^ 2;
  Gq = q / (L * A);
  //For T=T0 at r=0, from eqn 10.106
  T0 - T1 = Gq / (4 * k) * r1 ^ 2;
  //from eqn 10.107
  x = (T - T1) / (T0 - T) + 1;
  X = sqrt(x);
  r = r1 * 12 / X;
  
end Ex10_7;