//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.10 Page 279
//Title: Heat Transfer Coefficient of Stack Gases
//----------------------------------------------------
model Ex13_10
//----------------------------------------------------
//Parameter Section
parameter Real y(unit = "ft")=16 "Duct Length";
parameter Real vfs(unit = "ft/s")=50 "Gas Velocity";
//Properties of Air at 900 degF & 1 atm,(Appendix D)
parameter Real mu(unit = "cP")=0.0353 "Viscosity";
parameter Real rho(unit = "lb/ft3")=0.0291 "Density";
parameter Real cp(unit = "Btu/(lb.degF")=0.260 "Specific heat capacity";
parameter Real NPr(unit = "NULL")=0.69 "Prandtl Number";
//----------------------------------------------------
//Variable Section
Real NRe_y(unit = "NULL")"Reynolds Number";
Real delta(unit = "ft") "Boundary Layer Thickness";
//Heat Transfer Coefficient
Real h_Re(unit = "Btu/(hr.ft2.degF)") "HTC-Reynolds Analogy";
Real h_Co(unit = "Btu/(hr.ft2.degF)") "HTC-Colburn Analogy";
//----------------------------------------------------
//Equation Section
equation
NRe_y = (y * vfs * rho)/(mu * 6.72e-4);
//By Eqn 13.25
delta = (y * 0.376)/(NRe_y ^ 0.2);
//By Eqn 13.102, (vfs in ft/hr)
h_Re = (cp * vfs * 3600 * rho * 0.037)/(NRe_y ^ 0.2);
//By Eqn 13.110,
h_Co = h_Re/(NPr ^ (2/3));

end Ex13_10;