//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.12 Page 287
//Title: Heat Transfer Coefficient in Horizontal Tube
//----------------------------------------------------
model Ex13_12
//----------------------------------------------------
//Parameter Section
parameter Real D(unit = "in")=(3/8) "Diameter of Tube";
parameter Real L(unit = "ft")=3.21 "Tube Length";
parameter Real v(unit = "ft/s")=(0.3) "Water Velocity";
//Water properties at bulk temperature 125 degF (Appendix D)
parameter Real mu(unit = "cP")=0.58 "Viscosity";
parameter Real rho(unit = "lb/ft3")=61.5 "Density";
parameter Real k(unit = "Btu/(hr.ft.degF")=0.37 "Thermal Conductivity";
parameter Real cp(unit = "Btu/(lb.degF")=1 "Specific heat capacity";
parameter Real mu1(unit = "cP")=0.23 "Viscosity at tube wall temperature 225 degF";
//----------------------------------------------------
//Variable Section
Real NRe(unit = "") "Reynolds Number";
Real j_q(unit = "") "Colburn Factor for Heat Transfer";
Real NPr(unit = "") "Prandtl Number";
Real h(unit = "Btu/(hr.ft2.degF)") "Heat transfer coefficient";
//----------------------------------------------------
//Equation Section
equation
NRe = (D * v * rho)/(12 * mu * 6.72e-4);
j_q = 1.86 * NRe^(-2/3) * ((D/12)/L)^(1/3) ;
NPr = (cp * mu * 2.42)/k;
h = (j_q * rho * cp * v * 3600) * (NPr ^ (-2/3)) * ((mu/mu1)^0.14) ;

end Ex13_12;