//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.13 Page 290
//Title: Heat Transfer Rate in Vertical plate
//----------------------------------------------------
model Ex13_13
//----------------------------------------------------
//Parameter Section
parameter Real d(unit = "m")=1 "Plate width";
parameter Real mu(unit = "kg/(m.s")=2e-5 "Viscosity of air";
parameter Real k(unit = "J/(s.m2.(degC/m))")=0.027 "Thermal Conductivity of air";
parameter Real cp(unit = "J/kg")=1045 "Specific heat of air";
parameter Real g(unit = "m/s2")=9.8 "Gravitational Acceleration";
//T_plate = 90 degC and T_air = 25 degC
parameter Real Tav(unit = "degC")=(90+25)/2 "Average temperature";
parameter Real del_T(unit = "degC")=(90-25) "Temperature Difference";
//----------------------------------------------------
//Variable Section
Real rho(unit = "kg/m3") "Air density";
Real beta(unit = "K^(-1)") "Fractional volume increase/ deg temperature rise";
Real NGr(unit = "") "Grashof No.";
Real NPr(unit = "") "Prandtl No.";
Real Nu(unit = "") "Nusselt No.";
Real h(unit = "Btu/(hr.ft2.degF)") "Heat transfer coefficient";
Real h_m(unit = "J/(s.m2.degC)") "Heat transfer coefficient in mks units";
Real q(unit = "J/s") "Heat Transfer Rate";
//----------------------------------------------------
//Equation Section
equation
//From perfect gas law
rho = (29/22.4) * (273/(273+Tav)) ;
beta = 1/(273+Tav) ;
NGr = ((d^3)*(rho^2)*g*beta*del_T) / (mu^2);
NPr = (cp * mu)/k;
//Eqn 13.136
Nu = 0.021 * ((NGr * NPr)^(2/5));
//Eqn 13.137
h = 0.19 * ((del_T * 1.8)^(1/3)) ;
h_m = h * 5.674465;
//Plate area = 1 m2
q = h_m * 1 * del_T ;

end Ex13_13;