//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 14: Interphase Transfer
//Example 14.4 Page 317
//Title: Quenching of cylindrical steel shaft
//--------------------------------------------------
model Ex14_4
//--------------------------------------------------
//Parameter Section
parameter Real T_0(unit = "degF")=1100 "Temperature of Shaft";
parameter Real T2(unit = "degF")=300 "Temperature of Oil Bath";
parameter Real theta(unit = "hr")=(2/60) "Quenching time";
parameter Real alpha(unit = "ft2/hr")=0.35 "Thermal Diffusivity";
parameter Real k(unit = "Btu/(hr.(ft2).(degF/ft))")=26 "Thermal Conductivity of shaft";
parameter Real h(unit = "Btu/(hr.(ft2).degF")=150 "Surface Heat transfer coefficent";
parameter Real x(unit = "in")=1 "Distance from shaft center";
parameter Real x1(unit = "in")=2 "Radius of Shaft";
//--------------------------------------------------
//Variable Section
//For figure 11.4
Real X(unit = "NULL") "Exponent Term";
Real n(unit = "NULL") "Parameter for graph";
Real m(unit = "NULL") "Parameter for graph";
Real T(unit = "degF") "Temperature at 1 in from shaft center";
//--------------------------------------------------
//Equation Section
equation 
X = (alpha * theta)/((x1/12) ^ 2);
n = x/x1;
m = k/(h * (x1/12));
//Y = (T2-T)/(T2-T_0)
//Using the obtained values of X, n and m,
//From Figure 11.4, Y = 0.58
(T2 - T)/(T2 - T_0) = 0.58;

end Ex14_4;