//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 16: Mass Transfer
//Example 16.2 Page 400
//Title: HTU for SO2 Absorption in water
//--------------------------------------------------
model Ex16_2
//--------------------------------------------------
//Parameter Section
parameter Real Gv(unit = "lb/(hr.ft2)")=210 "Vapour phase flow rate";
parameter Real Gl(unit = "lb/(hr.ft2)")=8205 "Liquid phase flow rate";
parameter Real Mv(unit = "lb/lb mol")=29 "Molecular mass of air";
parameter Real Dp(unit = "ft")=1/12 "Diameter of packing";
parameter Real R(unit = "(atm.ft3)/(lb mol.degR)")=0.7302 "Gas Constant";
parameter Real T(unit = "degR")=87+459 "Temperature-Rankine Scale";
//For SO2 in air, at 87degF & 1atm
parameter Real mu_v(unit = "lb/(ft.hr)")=0.044 "Vapour phase viscosity";
parameter Real rho_v(unit = "lb/ft3")=0.0726 "Vapour phase density";
parameter Real D_v(unit = "ft2/hr")=0.5 "Diffusivity of SO2 in air";
//From Table 16.1
parameter Real av(unit = "ft2/ft3")=58 "Interfacial area";
//For SO2 in water, at 87degF & 1atm
parameter Real mu_L(unit = "lb/(ft.hr)")=2.42 "Liquid phase viscosity";
parameter Real rho_L(unit = "lb/ft3")=62.2 "Liquid phase density";
parameter Real D_L(unit = "ft2/hr")=6.58e-5 "Diffusivity of SO2 in water";
//From table 16.3
parameter Real sigma_w(unit = "dynes/cm")=71 "Surface Tension of water";
parameter Real sigma_p(unit = "dynes/cm")=61 "Surface Tension of packing";
//--------------------------------------------------
//Variable Section
Real t1(unit = "NULL") "Term in RHS of eqn 16.47";
Real t2(unit = "NULL") "Term in RHS of eqn 16.47";
Real t3(unit = "NULL") "Term in RHS of eqn 16.47";
Real aw(unit = "ft2/ft3") "Wetted Surface";
Real k_G(unit = "lb mol/(hr.ft2.atm)") "Vapour phase Mass Transfer coefficient";
Real k_L(unit = "lb mol/(hr.ft2.atm)") "Liquid phase Mass Transfer coefficient";
Real H_G(unit = "ft") "HTU for vapour phase";
Real H_L(unit = "ft") "HTU for liquid phase";
//--------------------------------------------------
//Libraries Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//From eqn 16.47, 
t1 = (Gl/(av*mu_L))^0.1 ;
t2 = (((Gl^2)*av)/((rho_L)^2 * 4.17e+8))^(-0.05) ; //g=4.17e+8 ft/s2
t3 = ((Gl^2)/(rho_L * 2027000 * av))^0.2 ; //(sigma_w=2027000 lb/hr2)
aw = av * (1 - exp(-1.45 * (sigma_p/sigma_w)^0.75 * t1 * t2 * t3)) ;
//From eqn 16.46,
k_G = 5.23 * (av*D_v/(R*T)) * (Gv/(av*mu_v))^0.7 * ((mu_v/(rho_v*D_v))^(1/3)) * (av*Dp)^(-2) ;
//From eqn 16.45,
k_L = 0.0051 * (((mu_L * 4.17e+8)/rho_L)^(1/3)) * ((Gl/(aw*mu_L))^(2/3)) * ((mu_L/(rho_L*D_L))^(-1/2));
//Refer Tables 13.2 & 16.2
H_G = (Gv/Mv)/(k_G * aw *1); //P=1 atm
H_L = Gl/(k_L * aw * rho_L) ;

end Ex16_2;