//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 19:Simultaneous Heat and Mass Transfer-Evaporation & Crystallization
//Example 19.4 Page 522
//Title: Na2SO4-H2O mixture at 50 degF
//--------------------------------------------------
model Ex19_4
//--------------------------------------------------
//Parameter Section
parameter Real[2] H(each unit = "Btu/lb")={4,18} "Enthalpy of Na2SO4 & H2O";
parameter Real[2] x(each unit = "")={0.5,0.5} "Composition";
parameter Real M(unit = "lb")=2 "Amount of mixture";
//--------------------------------------------------
//Variable Section
Real Hmix(unit = "Btu/lb") "Enthalpy of Mixture";
Real A(unit = "lb") "Amount of 32.7% saturated Na2SO4 Solution";
Real B(unit = "lb") "Amount of Na2SO4.10H2O in mixture";
Real C(unit = "lb") "Amount of Na2SO4 in mixture";
//--------------------------------------------------
//Equation Section
equation
Hmix = (H[1]*x[1]) + (H[2]*x[2]);
//From Hmix, using fig.19.28,
//Temperature at equilibrium = 90 degF
//Mixture contains Na2SO4, Na2SO4.10H2O and 32.7% sat. Na2SO4 solution
//From the relative distances in fig.19.30
A = (3.33/1.79) * (M-A);
B = (1.88/4.06) * (M-A-B);
C = M-A-B;

end Ex19_4;