//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.2 Page 546
//Title: Pump-Horsepower Calculation
//--------------------------------------------------
model Ex20_2
//--------------------------------------------------
//Parameter Section
parameter Real d(unit = "ft")=3/12 "I.D of pipe";
parameter Real del_z1(unit = "ft")=160 "Distance between reservoir surface & tank surface";
parameter Real del_z2(unit = "ft")=170 "Distance between points 2 and 4";
parameter Real Q(unit = "gal/min")=150 "Volumetric flow rate";
parameter Real F(unit = "(ft.lb)/ft")=35 "Energy loss due to friction";
parameter Real P2(unit = "lbf/ft2")=2743 "Pressure at pump inlet";
parameter Real P4(unit = "lbf/ft2")=14.7*144 "Pressure at top of tank=1atm";
parameter Real E(unit = "NULL")=0.55 "Overall Efficiency of pump motor";
parameter Real rho(unit = "lb/ft3")=62.3 "Density of water";
//--------------------------------------------------
//Variable Section
Real S(unit = "m2") "Cross-sectional area";
Real v(unit = "ft/s") "Average fluid velocity";
Real Wf1(unit = "(ft.lb)/ft") "Theoretical work requirement between 1&4";
Real Wf2(unit = "(ft.lb)/ft") "Theoretical work requirement between 2&4";
Real Power(unit = "hp") "Power required for pumping";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
S = pi * (d^2)/4;
v = ((Q*8.34)/(60*rho))/S ; //Conversion of gal/min to ft3/s

//Between points 1 & 4
//Since del_E = 0, v1=v4=0 (liquid levels remain constant), P1=P4=1atm, Q'=0
//By eqn 20.14
Wf1 = del_z1 + F;

//Between points 2 & 4
//v2=v, v4=0 hence KE correction factor,alpha=0.94 is used
(P2/rho) + ((v^2)/(2*32.2*0.94)) = (P4/rho) + del_z2 + Wf2 + F;

//Work done by the pump is +ve while work done on the pump is -ve
//Any set of reference points gives same theoretical work requirement
//Actual work done = theoretical work/pump efficiency
//Hence taking Wf1 for Power calculation

Power = (Wf1 * v * S * rho)/(550 * E) ; 

end Ex20_2;