//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.3 Page 553
//Title: Pumping of water to building
//--------------------------------------------------
model Ex20_3
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "lb/ft3")=62.3 "Density of water(Appendix D-12)";
parameter Real mu(unit = "lb/(ft.s)")=1*6.72e-4 "Viscosity of water(Appendix C-9)";
parameter Real Q(unit = "gal/min")=625 "Flow Rate of water";
parameter Real del_z(unit = "ft")=200 "Distance between reservoir surface & tank surface";
parameter Real L1(unit = "ft")=200 "Length of pipe from reservoir to pump";
parameter Real L2(unit = "ft")=75 "Length of shorter pipe before building";
parameter Real L3(unit = "ft")=250 "Length of pipe to tank from ground";
parameter Real eta(unit = "")=0.6 "Overall Pump Efficiency";
parameter Real C(unit = "$/kWh")=0.08 "Electricity cost per kWh";
//Subscripts a & b refer to 6-in and 4-in pipes resp.
parameter Real Da(unit = "ft")=6.065/12 "Diameter of 6-in pipe (Appendix C-6)";
parameter Real Db(unit = "ft")=4.046/12 "Diameter of 4-in pipe (Appendix C-6)";
//--------------------------------------------------
//Variable Section
Real v_a(unit = "ft/s") "Average velocity in 6-in pipe";
Real v_b(unit = "ft/s") "Average velocity in 4-in pipe";
Real NRe_a(unit = "") "Reynolds Number:6-in pipe";
Real NRe_b(unit = "") "Reynolds Number:4-in pipe";
Real L_a(unit = "ft") "Total equivalent length:6-in pipe";
Real L_b(unit = "ft") "Total equivalent length:4-in pipe";
Real F_a(unit = "ft.lbf/lb") "Frictional Loss:6-in pipe";
Real F_b(unit = "ft.lbf/lb") "Frictional Loss:4-in pipe";
Real F_t(unit = "ft.lbf/lb") "Total frictional Loss";
Real Wf(unit = "kWh/hr") "Work done by the pump";
Real Wf_act(unit = "kWh/hr") "Actual Work done by the pump";
Real Tc(unit = "$/day") "Total cost for pumping";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
v_a = (Q/60)*(0.1334 * 4/(pi * (Da ^2)));
NRe_a = (Da * v_a * rho)/mu ;
//In 6-in pipe, losses occur due to entrance,2 90-deg elbows & 1 gate valve
//Hence L-eq of fittings=63.9ft
L_a = 63.9 + L1 + L2;
//gc = 32.2;From Appendix C-1, for relative roughness=3e-4, f=0.017
//By eqn 20.22
F_a = (0.017 * (v_a ^2) * L_a) / (2 * 32.2 * Da);

v_b = v_a * ((Da ^ 2)/(Db ^ 2));
NRe_b = (Db * v_b * rho)/mu ;
//In 6-in pipe, losses occur due to sudden reduction,3 90-deg elbows,1 gate valve & sudden enlargement //Hence L-eq of fittings=60ft
L_b = 60 + L3;
//gc = 32.2;From Appendix C-1, for relative roughness=4.4e-4, f=0.0175
//By eqn 20.22
F_b = (0.0175 * (v_b ^2) * L_b) / (2 * 32.2 * Db);
F_t = F_a + F_b;

//Since g/gc = 1 lbf/lb
Wf = (del_z + F_t) * (Q*8.34*0.746/33000) ;
Wf_act = Wf / eta ;
Tc = Wf_act * C * 24 ;

end Ex20_3;