//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.1 Page 614
//Title: Terminal velocity of rain drops
//--------------------------------------------------
model Ex22_1
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "kg/(m^3)")=1.206 "Density of air";
parameter Real rho_s(unit = "kg/(m^3)")=1000 "Density of water";
parameter Real Dp(unit = "m")=0.001 "Particle diameter";
parameter Real mu(unit = "(N.s)/(m^2)")=20e-06 "Viscosity of air";
parameter Real g(unit = "m/(s^2)")=9.80665 "Acceleration due to gravity";
//--------------------------------------------------
//Variable Section
Real CD(unit = "NULL") "Drag coefficient";
Real vt(unit = "m/s") "Terminal Velocity";
//--------------------------------------------------
//Equation Section
equation
CD =  (4 * g * (Dp^3) * rho * (rho_s - rho))/(3 * (mu ^ 2 ));
//For Reynolds number=1 and the above CD,
//From Fig.22.1a, Reynolds no=(Dp*vt*rho)/mu=190
vt = (190 * mu)/(Dp * rho);

end Ex22_1;