//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.3 Page 627
//Title: Centrifugation of liquid detergent
//--------------------------------------------------
model Ex22_3
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "g/(cm^3)")=(0.8*62.4) "Density of liquid detergent";
parameter Real rho_s(unit = "g/(cm^3)")=(1.46*62.4) "Density of sodium sulphate";
parameter Real mu(unit = "cP")=(100*2.42) "Viscosity of liquid detergent";
parameter Real n(unit = "rpm")=23000 "Centrifuge speed";
parameter Real Q1(unit = "lb/hr")=5 "Throughput of lab centrifuge";
//Centrifuge Dimensions
parameter Real l(unit = "ft")=7.75/12 "Length of centrifuge";
parameter Real r2(unit = "ft")=0.875/12 "Outer radius";
//Since r2-r1=19/32=0.59375 inch
parameter Real r1(unit = "ft")=0.281/12 "Inner radius";
//From Table 22.1, sigma values are obtained
parameter Real sigma_1(unit = "NULL")=1290 "Lab Super-centrifuge sigma value";
parameter Real sigma_2(unit = "NULL")=72600 "No.2 Disk Centrifuge sigma value";
//--------------------------------------------------
//Variable Section
Real omega(unit = "rad/s") "Angular velocity of centrifuge";
Real V(unit = "(ft^3)") "Volume of Centrifuge";
Real del_rho(unit = "lb/ft3") "Density Difference";
Real A(unit = "") "ln Term in E1n. 22.37";
Real Dp(unit = "ft") "Critical Particle Diameter";
Real Q2(unit = "lb/hr") "Throughput of No.2 Disk Centrifuge";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
omega = (2*pi*n*60)^2;
V = l*pi*((r2^2)-(r1^2));
del_rho = rho_s - rho;
A = 2* log(r2/r1);
//By Eqn. 22.37
Dp = sqrt((9 * mu * Q1 * A)/(rho * del_rho * omega * V)); 

Q2 = (Q1 * sigma_2)/sigma_1;

end Ex22_3;