//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.8 Page 641
//Title: Pressure drop across bed in Regenerative Heater 
//--------------------------------------------------
model Ex22_8
//--------------------------------------------------
//Parameter Section
parameter Real d(unit = "in")=0.25 "Side of cubic particle";
parameter Real L(unit = "ft")=10 "Bed Length";
parameter Real T1(unit = "degR")=80+459.67 "Temperature of air entering";
parameter Real T2(unit = "degR")=400+459.67 "Temperature of air at exit";
parameter Real P(unit = "psia")=100 "System Pressure";
parameter Real G(unit = "lb/(hr.ft2)")=1000 "Mass Rate";
parameter Real mu(unit = "lb/(ft.hr)")=0.023*2.42 "Viscosity of medium";
parameter Real R(unit = "ft3.psi/(lbmol.degR)")=10.73 "Gas Constant";
parameter Real gc(unit = "lbm.ft/(lbf.hr2)")=32.2*(3600^2);
//For psi=0.806, from figure B-12,
parameter Real e(unit = "")=0.44 "Bed Porosity";
//--------------------------------------------------
//Variable Section
Real Dp(unit = "in") "Particle Diameter";
Real rho1(unit = "lb/ft3") "Air Density at T1";
Real rho2(unit = "lb/ft3") "Air Density at T2";
Real v_sm(unit = "ft/hr") "Mean Superficial Velocity";
Real NRe_by_Porosity_term(unit = "") "NRe/(1-e)";
Real del_P(unit = "psia") "Pr. Drop across the Bed";
//--------------------------------------------------
//Equation Section
equation
//6Vp/Ap formula (cubes)
Dp = (6*(d^3))/(6*(d^2)) ; 
//MW of air,M=29
rho1 = (P*29)/(R*T1);
rho2 = (P*29)/(R*T2);
//Since Pressure drop has very small effect on the gas density
v_sm = ((G/rho1)+(G/rho2))/2 ;
NRe_by_Porosity_term = (Dp * G)/(12 * mu * (1-e)) ;
//Using the value of NRe/(1-e) in figure 22.30,
del_P = (2 * L * G * v_sm * (1-e)) / (144 * gc * (Dp/12) * (e^3)) ;

end Ex22_8;