//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.9 Page 645
//Title: Superficial Gas velocity in Fluidized Reactor 
//--------------------------------------------------
model Ex22_9
//--------------------------------------------------
//Parameter Section
parameter Real Dp(unit = "ft")=(0.05/(25.4*12)) "Particle Diameter";
parameter Real L(unit = "ft")=3 "Length of bed";
parameter Real e(unit = "")=0.35 "Porosity at rest";
parameter Real e0(unit ="")=0.42 "POrosity at minimum fluidization";
parameter Real rho_s(unit = "lb/ft3")=1.65*62.4 "Density of catalyst";
parameter Real rho(unit = "lb/ft3")=0.21 "Density of fluid";
parameter Real mu(unit = "lb/(ft.s)")=0.02 "Viscosity of fluid";
parameter Real g(unit = "lbm.ft/(lbf.s2)")=32.2;
//--------------------------------------------------
//Variable Section
Real del_rho(unit = "lb/ft3") "Density Difference";
Real v_sm0(unit = "ft/s") "Mean Superficial Velocity at min. fluidization";
Real v_t(unit = "ft/s") "Settling Velocity";
Real v_sm(unit = "ft/s") "Mean Superficial Velocity";
Real epsilon(unit = "") "Porosity at v_sm";
Real LHS(unit = "") "LHS of eqn 22.93";
Real L_by_L0(unit = "") "Ratio of height of bed";
//--------------------------------------------------
//Equation Section
equation
del_rho = rho_s - rho ;
//Eqn 22.91
v_sm0 = ((e0^3)/(1-e0)) * ((del_rho * g * (Dp^2)) / (150 * mu * 6.72e-4)) ;
//Eqn 22.15
v_t = (del_rho * g * (Dp^2)) / (18 * mu * 6.72e-4);
v_sm = (v_t + v_sm0)/2 ;
//By eqn 22.92,
(epsilon^3)/(1-epsilon) = ((150*mu*6.72e-4*(v_sm - v_sm0))/(del_rho*g*(Dp^2))) + ((e0^3)/(1-e0));
//By eqn 22.93, LHS = NFr * NRe * (del_rho/rho) * (L/Dp)
LHS = ((v_sm0^3) * del_rho * L * (1-e))/(g * mu * 2.42 * Dp * (1-e0));
L_by_L0 = (1-e0)/(1-epsilon) ;
//Slugging occurs-->Muss less expansion of bed than calculated.

end Ex22_9;