//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 5: Countercurrent Multistage Operations
//Example 5.3 Page 66
//Title: Recovery With Infinite No. of Stages
//--------------------------------------------
model Ex5_3
//--------------------------------------------
//Parameter Section
parameter Real ma(unit = "kg/hr")=2000 "Mass Flow Rate of Acetic Acid";
parameter Real xa(unit = "NULL")=0.4 "Solute Concentration in Feed";
//From Figure5.8, for V/L=1,
parameter Real y1a(unit = "NULL")=0.235 "Solute Concentration in Extract";
//By Inverse Lever-Arm Rule
parameter Real V1(unit = "kg/hr")=2910 "Mass Flow Rate of Exiting Vapour";
//--------------------------------------------
//Variable Section
Real R(unit = "%") "Solute Recovery";
//--------------------------------------------
//Equation Section
equation
R = (V1 * y1a * 100)/(ma * xa);

end Ex5_3;