//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.1 Page 167
//Title: Transport Rate of Methane
//--------------------------------------------
model Ex9_1
//--------------------------------------------
//Parameter Section
parameter Real P(unit = "N/(m^2)")=10^5 "Total Pressure";
parameter Real xa1(unit = "NULL")=0.9 "Mole Percent of Methane in Tank 1";
parameter Real xa2(unit = "NULL")=0.05 "Mole Percent of Methane in Tank 2";
//Tanks are connected by a tube of length 150mm
parameter Real z1(unit = "m")=0;
parameter Real z2(unit = "m")=0.15;
parameter Real d(unit = "m")=0.002;
parameter Real D(unit = "(m^2)/s")=1.57e-5 "Diffusivity of Methane at 100kPa and 0 degC";
parameter Real R(unit = "(Pa.(m^3))/(mol.K)")=8.3144 "Universal Gas Constant";
parameter Real T(unit = "K")=273.15 "Temperature of Tanks is 0 degC";
//--------------------------------------------
//Variable Section
Real Pa1(unit = "N/(m^2)") "Partial Pressure of Methane at Tank 1";
Real Pa2(unit = "N/(m^2)") "Partial Pressure of Methane at Tank 2";
Real A(unit = "m^2") "Cross-Sectional Area";
Real Na(unit = "mol/s") "Rate of Transport of Methane";
//--------------------------------------------
//Library section
extends Modelica.Constants;
//--------------------------------------------
//Equation Section
equation
//By Raoult's Law
Pa1 = xa1 * P;
Pa2 = xa2 * P;
A = pi * ((d^2)/4);
Na = -(D * A * (Pa2-Pa1))/(R * T * (z2-z1));

end Ex9_1;
