//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.12 Page 181
//Title: Viscosity of liquid water at 20 degC
//--------------------------------------------------
model Ex9_12
//--------------------------------------------------
//Parameter Section
parameter Real T(unit = "K")=293 "Temperature 20 degC";
parameter Real Tb(unit = "K")=373 "Normal Boiling Point - 100 degC";
parameter Real rho(unit = "kg/(m^3)")=0.998e+3 "Density of Water";
parameter Real M(unit = "kg/mol")=18e-3 "Molecular mass of water";
//--------------------------------------------------
//Variable Section
Real V(unit = "(m^3)/mol") "Molar volume of Water @ 20 degC";
Real mu(unit = "kg/(m.s)") "Viscosity of water @ 20 degC";
//--------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//--------------------------------------------------
//Equation Section
equation
V = M/rho;
//From Eqn 9.56,
mu = (4e-10 * exp((3.8 * Tb)/T)) / V;

end Ex9_12;