//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.3 Page 171
//Title: 2 Vertical Parallel Plates
//--------------------------------------------
model Ex9_3
//--------------------------------------------
//Parameter Section
parameter Real x1(unit = "m")=0;
parameter Real x2(unit = "m")=0.01;
parameter Real v1(unit = "m/s")=5 "Velocity of Left-Hand Plate";
parameter Real v2(unit = "m/s")=0 "Velocity of Right-Hand Plate";
parameter Real mu(unit = "N.s/m2")=0.1 "Viscosity of Heavy oil";
parameter Real gc(unit = "kg.m/(s2.N)")=1 "Gravitational Constant";
//--------------------------------------------
//Variable Section
Real tau(unit = "N/m2") "Force per unit area required to maintain Left plate's Motion";
Real Flux(unit = "kg/(m.s2)") "Momentum Flux at surface of each plate";
//--------------------------------------------
//Equation Section
equation
//(a)
tau = - (mu/gc) * ((v2-v1)/(x2-x1));

//(b): Since Velocity is Linear and Viscosity constant, 
//Shear Stress is also Constant from one plate to another
//Force exerted by oil per unit area of right plate is also the same as tau

//(c): Momentum Flux at any point is equal to the shear stress
Flux = tau * gc ;
end Ex9_3;