//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.6 Page 177
//Title: Argon-Viscosity
//--------------------------------------------
model Ex9_6
//--------------------------------------------
//Parameter Section
parameter Real M(unit = "kg/mol")=39.9e-3 "Molecular Weight of Argon";
parameter Real T(unit = "K")=273 "Temperature 0 degC";
parameter Real sigma(unit = "m")=3.418e-10 "Molecular Diameter";
//From Appendix D-6a, D-6b
parameter Real Omega(unit = "NULL")=1.138 "Collision Integral";
//--------------------------------------------
//Variable Section
Real mu(unit = "kg/(m.s)") "Argon's Viscosity at 0 degC and 1 atm";
//------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//--------------------------------------------
//Equation Section
equation
mu = (8.44e-25 * sqrt(M * T))/((sigma^2) * Omega);

end Ex9_6;