//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 10:Differential Mass, Heat and Momentum Balances
//Example 10.4 Page 200
//Title: Rate of Loss of MeOH from tank
//--------------------------------------------------
model Ex10_4
//--------------------------------------------------
//Parameter Section
parameter Real x1(unit = "ft")=0 "Surface of methanol";
parameter Real x2(unit = "ft")=2 "Top of Tank";
parameter Real pa1(unit = "mmHg")=135 "Partial Pr. of MeOH at x1";
parameter Real pa2(unit = "mmHg")=0 "Partial Pr. of MeOH at x2";
parameter Real P(unit = "mmHg")=760 "Total Pressure";
parameter Real R(unit = "(ft3.mmHg)/(lb mole.degR)")=(0.7302*760) "Gas Constant";
parameter Real T(unit = "degR")=537 "System temperature";
parameter Real D(unit = "ft2/hr")=0.62 "Diffusivity of MeOH in air";
//--------------------------------------------------
//Variable Section
Real Nat(unit = "lb mole/hr") "Rate of loss of MeOH";
Real Na(unit = "lb mole/hr") "Loss of MeOH due to Molecular Transport";
//--------------------------------------------------
//Library section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//From Figure 10.5, by geometric considerations,
//Area varies as A = (pi/4)*((6-x)^2)
//Hence by integration of equation 10.64
Nat * (4/pi) * ((1/(6-x2))-(1/(6-x1))) = ((D*P)/(R*T)) * log((P-pa2)/(P-pa1));
Na = (P-pa1) * Nat/P;

end Ex10_4;